/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*             EEPROM Emulation Driver for S12XS/S12P                   *
*                                                                      *
* FILE NAME     :  SSD_SGF18.h                                         *
* DATE          :  06.04.2008                                          *
*                                                                      *
* AUTHOR        :  Infosys Team, Mysore                                *
* E-mail        :  r56611@freescale.com                                *
*                                                                      *
************************************************************************/

/******************************* CHANGES *******************************
 0.0a   10.09.2007      Sindhu R01      Initial Version
 1.0    04.28.2008      Sindhu R01      Added macros relating to DEAD
                                        sectors, Added prototypes of
                                        function FlashSetUserMargin()
 1.1    06.04.2008      Sindhu R01      Removed the SSD Configuration
                                        structure. CallBack and
                                        commandArray global variables are externed.
                                        Added EPAGE manipulation macros for
                                        reading D-Flash locations.
                                        Added the macros to select S12XS or
                                        the S12P family
1.2    10.09.2009      Carlos Galuzio   Cleaned up uncessary code to run the AN                    
***********************************************************************/

#ifndef _SSD_SGF18_H_
#define _SSD_SGF18_H_

#define CODE_WARRIOR                      0x00
#define COSMIC_BANKED                     0x01

#define S12XS_64                          0x00
#define S12XS_128_256                     0x01
#define S12P                              0x02

/*--------------- SUBJECT TO CHANGES ACCORDING TO COMPILER -------------*/
/*For selecting Codewarrior compiler define COMPILER_SELECT as CODE_WARRIOR   */
/*For selecting Cosmic compiler define COMPILER_SELECT as COSMIC_BANKED */
#define COMPILER_SELECT                   CODE_WARRIOR

/*For selecting S12XS 64k as D-Flash size, define SGF18_SELECT as S12XS_64   */
/*For selecting S12XS 128k or 256k as D-Flash size, define SGF18_SELECT as S12XS_128_256   */
/*For selecting S12P family define SGF18_SELECT as S12P_SGF18   */
#define SGF18_SELECT                      S12XS_128_256

/*-------------------- Callback function enable ------------------*/
#define CALLBACK_ENABLE                 FALSE


#if (CODE_WARRIOR == COMPILER_SELECT)
  /* For CodeWarrior, the keyword is near or __near */
  #define SSD_SGF18_NEAR                  __near

 /* For CodeWarrior, the keyword is far or __far */
  #define SSD_SGF18_FAR                  __far
  #define SSD_SGF18_FUNC_FAR             __far
#else
  /* For Cosmic compiler, the keyword is @near  */
  #define SSD_SGF18_NEAR                  @near

  /* For Cosmic compiler, the keyword is @far  */
  #define SSD_SGF18_FAR                  @far @gpage
  #define SSD_SGF18_FUNC_FAR             @far
#endif

/* Configuration MACROS to be used */
/* Base address of MCU register block */
#define SSD_MCU_REGISTER_BASE           0x00000000

/* Bus clock. The unit is 10KHz */
#define SSD_BUS_CLOCK                   200

/* Oscillator clock. The unit is 10KHz */
#define SSD_OSCILLATOR_CLOCK            400

/*------------ Return Code Definition for HCS12X/S12P-SSD -------------------*/
#define SGF_OK                          0x0000
#define SGF_ERR_CLKSET                  0x0001
#define SGF_ERR_SIZE                    0x0002
#define SGF_ERR_RANGE                   0x0004
#define SGF_ERR_ACCERR                  0x0008
#define SGF_ERR_PVIOL                   0x0010
#define SGF_ERR_MGSTAT0                 0x0020
#define SGF_ERR_MGSTAT1                 0x0040
#define SGF_ERR_EPVIOLIF                0x0080
#define SGF_ERR_PROTMODE                0x0100
#define SGF_ERR_PROTSIZE                0x0200
#define SGF_ERR_DATAMISMATCH            0x0400
#define SGF_ERR_INVALIDCLK              0x0800
#define SGF_ERR_ADDR                    0x1000
#define SGF_ERR_SFDIF                   0x2000
#define SGF_ERR_DFDIF                   0x4000


/* Command Sequence Index Macros */
#define COMMAND_INDEX0                  0x00
#define COMMAND_INDEX1                  0x01
#define COMMAND_INDEX2                  0x02
#define COMMAND_INDEX3                  0x03
#define COMMAND_INDEX4                  0x04
#define COMMAND_INDEX5                  0x05


#if ((SGF18_SELECT == S12XS_64)|(SGF18_SELECT == S12XS_128_256)) /* If S12XS family */
  /* Address fetching mask */
  #define GLOBAL_ADDRESS_MASK             0x007F0000
  #define ADDRESS_OFFSET_MASK             0x0000FFFF

  /* D Flash data pertaining to S12XS device */

  /* Macros used for Reading D-Flash */
  #define DFLASH_LOWEST_START_PAGE        0x00
  #define DFLASH_START                    0x00100000
  #define DFLASH_PAGE_SIZE                0x0400
  #define DFLASH_PAGE_WINDOW_START        0x0800

  #define MMC2_EPAGE_OFFSET               0x0017

  /* D Flash block start address */
  #define DFLASH_BLOCK_START_ADDR         0x00100000

  /* D Flash sector size */
  #define DFLASH_SECTOR_SIZE              0x0100  /* 256 Bytes size */

#if (SGF18_SELECT == S12XS_128_256)
  /* D Flash maximum size */
  #define DFLASH_MAXIMUM_SIZE             0x00002000  /* 8 KB */
  /* D Flash end address */
  #define DFLASH_BLOCK_END_ADDR           0x00101FFF
#else
  /* D Flash maximum size */
  #define DFLASH_MAXIMUM_SIZE             0x00001000  /* 4 KB */
  /* D Flash end address */
  #define DFLASH_BLOCK_END_ADDR           0x00100FFF

#endif

  /* Read D-Flash Operation Macro(assumes the correct page value is loaded in EPAGE register */
  #define READ_DFLASH16(address)                 ((UINT16)(*(VUINT16 *)(((address - DFLASH_START) & (DFLASH_PAGE_SIZE - 1)) + DFLASH_PAGE_WINDOW_START)))

#else/* If S12P family */

  /* Address fetching mask */
  #define GLOBAL_ADDRESS_MASK             0x00030000
  #define ADDRESS_OFFSET_MASK             0x0000FFFF

  /* D Flash data pertaining to S12P device */

  /* D Flash block start address */
  #define DFLASH_BLOCK_START_ADDR         0x004400

  /* D Flash sector size */
  #define DFLASH_SECTOR_SIZE              0x0100  /* 256 Bytes size */

  /* D Flash maximum size */
  #define DFLASH_MAXIMUM_SIZE             0x00001000  /* 4 KB */

  /* D Flash end address */
  #define DFLASH_BLOCK_END_ADDR           0x0053FF

  #define DFLASH_PROGRAM_OFFSET           0x4000

  /* Read D-Flash Operation Macro */
  #define READ_DFLASH16(address)                 ((UINT16)(*(VUINT16 *)(address-DFLASH_PROGRAM_OFFSET)))

#endif

/* Maximum value for program & read once phrase index */
#define MAX_PHRASE_INDEX                0x07

/*-------------- Read/Write/Set/Clear Operation Macros ------------------*/
#if (CODE_WARRIOR == COMPILER_SELECT)
  /* CodeWarrior */
  #define REG_BIT_SET(address, mask)      (*(VUINT8 *SSD_SGF18_NEAR)(address) |= (mask))
  #define REG_BIT_CLEAR(address, mask)    (*(VUINT8 *SSD_SGF18_NEAR)(address) &= ~(mask))
  #define REG_BIT_TEST(address, mask)     (*(VUINT8 *SSD_SGF18_NEAR)(address) & (mask))
  #define REG_WRITE(address, value)       (*(VUINT8 *SSD_SGF18_NEAR)(address) = (value))
  #define REG_READ(address)               ((UINT8)(*(VUINT8 *SSD_SGF18_NEAR)(address)))
  #define REG_WRITE16(address, value)     (*(VUINT16 *SSD_SGF18_NEAR)(address) = (value))
  #define REG_READ16(address)             ((UINT16)(*(VUINT16 *SSD_SGF18_NEAR)(address)))

  #define WRITE8(address, value)          (*(VUINT8 *SSD_SGF18_NEAR)(address) = (value))
  #define READ8(address)                  ((UINT8)(*(VUINT8 *SSD_SGF18_NEAR)(address)))
  #define SET8(address, value)            (*(VUINT8 *SSD_SGF18_NEAR)(address) |= (value))
  #define CLEAR8(address, value)          (*(VUINT8 *SSD_SGF18_NEAR)(address) &= ~(value))
  #define TEST8(address, value)           (*(VUINT8 *SSD_SGF18_NEAR)(address) & (value))

  #define WRITE16(address, value)         (*(VUINT16 *SSD_SGF18_NEAR)(address) = (value))
  #define READ16(address)                 ((UINT16)(*(VUINT16 *SSD_SGF18_NEAR)(address)))
  #define SET16(address, value)           (*(VUINT16 *SSD_SGF18_NEAR)(address) |= (value))
  #define CLEAR16(address, value)         (*(VUINT16 *SSD_SGF18_NEAR)(address) &= ~(value))
  #define TEST16(address, value)          (*(VUINT16 *SSD_SGF18_NEAR)(address) & (value))

  #define WRITE32(address, value)         (*(VUINT32 *SSD_SGF18_NEAR)(address) = (value))
  #define READ32(address)                 ((UINT32)(*(VUINT32 *SSD_SGF18_NEAR)(address)))
  #define SET32(address, value)           (*(VUINT32 *SSD_SGF18_NEAR)(address) |= (value))
  #define CLEAR32(address, value)         (*(VUINT32 *SSD_SGF18_NEAR)(address) &= ~(value))
  #define TEST32(address, value)          (*(VUINT32 *SSD_SGF18_NEAR)(address) & (value))

#else
/* Cosmic compiler */
  #define REG_BIT_SET(address, mask)      (*(SSD_SGF18_NEAR VUINT8 *)(address) |= (mask))
  #define REG_BIT_CLEAR(address, mask)    (*(SSD_SGF18_NEAR VUINT8 *)(address) &= ~(mask))
  #define REG_BIT_TEST(address, mask)     (*(SSD_SGF18_NEAR VUINT8 *)(address) & (mask))
  #define REG_WRITE(address, value)       (*(SSD_SGF18_NEAR VUINT8 *)(address) = (value))
  #define REG_READ(address)               ((UINT8)(*(SSD_SGF18_NEAR VUINT8 *)(address)))
  #define REG_WRITE16(address, value)     (*(SSD_SGF18_NEAR VUINT16 *)(address) = (value))
  #define REG_READ16(address)             ((UINT16)(*(SSD_SGF18_NEAR VUINT16 *)(address)))

  #define WRITE8(address, value)          (*(SSD_SGF18_NEAR VUINT8 *)(address) = (value))
  #define READ8(address)                  ((UINT8)(*(SSD_SGF18_NEAR VUINT8 *)(address)))
  #define SET8(address, value)            (*(SSD_SGF18_NEAR VUINT8 *)(address) |= (value))
  #define CLEAR8(address, value)          (*(SSD_SGF18_NEAR VUINT8 *)(address) &= ~(value))
  #define TEST8(address, value)           (*(SSD_SGF18_NEAR VUINT8 *)(address) & (value))

  #define WRITE16(address, value)         (*(SSD_SGF18_NEAR VUINT16 *)(address) = (value))
  #define READ16(address)                 ((UINT16)(*(SSD_SGF18_NEAR VUINT16 *)(address)))
  #define SET16(address, value)           (*(SSD_SGF18_NEAR VUINT16 *)(address) |= (value))
  #define CLEAR16(address, value)         (*(SSD_SGF18_NEAR VUINT16 *)(address) &= ~(value))
  #define TEST16(address, value)          (*(SSD_SGF18_NEAR VUINT16 *)(address) & (value))

  #define WRITE32(address, value)         (*(SSD_SGF18_NEAR VUINT32 *)(address) = (value))
  #define READ32(address)                 ((UINT32)(*(SSD_SGF18_NEAR VUINT32 *)(address)))
  #define SET32(address, value)           (*(SSD_SGF18_NEAR VUINT32 *)(address) |= (value))
  #define CLEAR32(address, value)         (*(SSD_SGF18_NEAR VUINT32 *)(address) &= ~(value))
  #define TEST32(address, value)          (*(SSD_SGF18_NEAR VUINT32 *)(address) & (value))

#endif /* Compiler select */

/*-------------------- Macro definition for HCS12X ----------------------*/
#define HCS12X_WORD_SIZE                0x0002

/*--------------------- CallBack function period ------------------------*/
#define FLASH_CALLBACK               1   /* Used in Program Verify and Search Record */

/*-------------------- Callback function prototype ---------------------*/
/* If CallBack is enabled, then declare a callback function pointer type */
#if(CALLBACK_ENABLE == TRUE)
 typedef void (* PCALLBACK)(void);
#endif

/*--------------------Null Callback function defination ------------------*/
#define NULL_CALLBACK                   ((PCALLBACK)0xFFFFFFFF)

/* Phrase size */
#define FLASH_PHRASE_SIZE               0x0008  /* 8 bytes */

/* Global variables */
/* If CallBack is enabled, then declare a callback function pointer type */
#if(CALLBACK_ENABLE == TRUE)
  /* A function pointer to the CallBack function */
  extern PCALLBACK      CallBack; /* pointer to CallBack function */
#endif

/* A command array which contains the data to be written to the FCCOB register. */
extern UINT16 commandArray[6]; /* command sequence array */

/*---------------- Function Prototypes for Flash SSD --------------------*/

#pragma CODE_SEG DEFAULT


/* Flash initialization */
extern UINT16 FlashInit(void);

/* D flash program */
extern UINT16 DFlashProgram(UINT32 dest, UINT32 size, UINT32 source);

/* D flash erase */
extern UINT16 DFlashErase(UINT32 destination, UINT32 size);

/* D flash erase verify */
extern UINT16 DFlashEraseVerify(UINT32 destination, UINT32 size);

/* Flash program verify */
extern UINT16 FlashProgramVerify(UINT32 destination, UINT32 size, UINT32 source);

/* Flash set user margin */
extern UINT16 FlashSetUserMargin(UINT32 blockAddress, UINT16 marginValue);

/* Internal function. Called by driver APIs only */
/* Flash command sequence */

extern UINT16 FlashCommandSequence(UINT8 index);

#endif /* _SSD_SGF18_H_ */


